<?php
/**
 Template Name: Portfolio
 *
 *
 * @file           page.php
 * @package        SolidWP 
 * @author         Brad Williams
 * @copyright      2003 - 2013 Brag Interactive
 * @license        license.txt
 * @version        Release: 3.2.0
 * @link           http://codex.wordpress.org/Theme_Development#Pages_.28page.php.29
 * @since          available since Release 1.0
 */
 ?>
 <?php get_header(); ?>

<!-- *****************************************************************************************************************
 BLUE WRAP
 ***************************************************************************************************************** -->
 <div id="blue">
    <div class="container">
        <div class="row">
            <h3><?php the_title(); ?></h3>
        </div><!-- /row -->
    </div> <!-- /container -->
</div><!-- /blue -->

<!-- *****************************************************************************************************************
 TITLE & CONTENT
 ***************************************************************************************************************** -->

<?php if( rwmb_meta( 'wtf_portfolio_title' ) !== '' ) { ?>
 <div class="container mtb">
    <div class="row">
        <div class="col-lg-8 col-lg-offset-2 centered">
            <?php echo rwmb_meta( 'wtf_portfolio_title' ); ?>
            <br>
            <div class="hline"></div>
        </div>
    </div>
</div><! --/container -->
 <?php } ?> 

<!-- *****************************************************************************************************************
 PORTFOLIO SECTION
 ***************************************************************************************************************** -->
 <div id="portfoliowrap">
    <div class="portfolio-centered">
        <div class="recentitems portfolio">


            <?php
            $loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => -1));
            $count =0;
            ?>



            <?php if ( $loop ) : while ( $loop->have_posts() ) : $loop->the_post(); ?>

            <?php $terms = get_the_terms( $post->ID, 'portfolio_cats' );

            if ( $terms && ! is_wp_error( $terms ) ) : $links = array();

            foreach ( $terms as $term ){
                $links[] = $term->name;
            }

            $links = str_replace(' ', '-', $links);
            $tax = join( " ", $links );
            else :
            $tax = '';
            endif; ?>


            <div class="portfolio-item <?php echo strtolower($tax); ?>">
                <div class="he-wrap tpl6">
                    <?php the_post_thumbnail(); ?>
                    <div class="he-view">
                        <div class="bg a0" data-animate="fadeIn">
                            <h3 class="a1" data-animate="fadeInDown"><?php the_title(); ?></h3>
                            <?php $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID, 'portfolio-thumbnail') ); ?>
                            <a data-rel="prettyPhoto" href="<?php echo $url ?>" class="dmbutton a2" data-animate="fadeInUp"><i class="fa fa-search"></i></a>
                            <a href="<?php the_permalink() ?>" class="dmbutton a2" data-animate="fadeInUp"><i class="fa fa-link"></i></a>
                        </div>
                    </div>
                </div>
            </div>


        <?php endwhile; else: ?>

        <div class="error-not-found">Sorry, no portfolio entries for while.</div>

    <?php endif; ?>

</div><!-- portfolio -->
</div><!-- portfolio container -->
</div><!--/Portfoliowrap -->



<?php get_footer(); ?>