<?php
/**
 * Single Portfolio Template
 *
 *
 * @file           single-project.php
 * @package        SolidWP 
 * @author         Brad WIlliams 
 * @copyright      2003 - 2014 Brag Interactive
 * @license        license.txt
 * @version        Release: 3.2.0
 * @link           http://codex.wordpress.org/Theme_Development#Single_Post_.28single.php.29
 * @since          available since Release 1.0
 */
?>
<?php get_header(); ?>

<!-- *****************************************************************************************************************
 BLUE WRAP
 ***************************************************************************************************************** -->
  <div id="blue">
      <div class="container">
      <div class="row">
        <h3><?php the_title(); ?></h3>
      </div><!-- /row -->
      </div> <!-- /container -->
  </div><!-- /blue -->

<!-- *****************************************************************************************************************
   TITLE & CONTENT
   ***************************************************************************************************************** -->

       <?php if (have_posts()) : ?>

        <?php while (have_posts()) : the_post(); ?>

           <div class="container mt">
            <div class="row">
              <div class="col-lg-10 col-lg-offset-1 centered">
                

               <?php                           
               $images = rwmb_meta( 'wtf_imgadv', 'type=image' );
               $number = 0; 
               //echo print_r($images);
               if ($images) {
                ?>
                <div id="carousel" class="carousel slide" data-ride="carousel">

                     <!-- Indicators -->
                    <ol class="carousel-indicators">
                        <?php foreach ( $images as $image ) { ?>
                        <li data-target="#carousel" data-slide-to="<?php echo $number++; ?>"></li>
                      <?php } ?>
                    </ol>

                    <div class="carousel-inner">
                     <?php foreach ( $images as $image ) { 
                      echo "<div class='item'><img class='img-responsive' src='{$image['full_url']}' alt='{$image['alt']}' /></div>";
                    } ?>
                  </div><!-- carousel inner -->
                </div>  <!-- end carousel -->  
              <?php } else { 
               the_post_thumbnail();
                } ?>

            
            </div>
              
              <div id="post-<?php the_ID(); ?>" >
              <div class="col-lg-5 col-lg-offset-1">
          
                <div class="spacing"></div>
                <?php the_content(); ?>
              </div>
              
              <?php if( rwmb_meta( 'wtf_portfolio_right' ) !== '' ) { ?>
              <div class="col-lg-4 col-lg-offset-1">
                <div class="spacing"></div>
               <?php echo rwmb_meta( 'wtf_portfolio_right' ); ?>
              </div>
              <?php } ?> 
              
                 <footer class="article-footer">
                <div class="post-edit"><?php edit_post_link(__('Edit', 'responsive')); ?></div>   
                </footer> 
               </div><!-- end of #post-<?php the_ID(); ?> -->
            </div><! --/row -->
           </div><! --/container -->


              <?php
    /*-----------------------------------------------------------------------------------*/
    // Related posts if not disabled 
    /*-----------------------------------------------------------------------------------*/
    
         if(rwmb_meta('wtf_single_port_radio') == 'value1') :
            $bi_port_cats = wp_get_post_terms(get_the_ID(), 'portfolio_cats');
            if ( $bi_port_cats ) :  ?>
               
           <div id="portfoliowrap">
        <div class="portfolio-centered">
          <h4 class="title">RELATED ITEMS</h4>

          <div class="recentitems portfolio">
                   
                    
                    <?php
                    $args = array(
                        'post__not_in' => array( get_the_ID() ),
                        'orderby'=> 'post_date',
                        'order' => 'rand',
                        'post_type' => 'portfolio',
                        'posts_per_page' => 5,
                        'tax_query' => array(
                            'relation' => 'OR',
                            array(
                                'taxonomy' => 'portfolio_cats',
                                'terms' => $bi_port_cats[0]->term_id
                            ),
                        )
                    );
                    $my_query = new WP_Query($args);
                    if( $my_query->have_posts() ) {
                    $count=0;
                    while ( $my_query->have_posts()) : $my_query->the_post();
                        $count++; ?>

                            <div class="portfolio-item">
                              <div class="he-wrap tpl6">
                                  <?php the_post_thumbnail(); ?>
                                  <div class="he-view">
                                      <div class="bg a0" data-animate="fadeIn">
                                          <h3 class="a1" data-animate="fadeInDown"><?php the_title(); ?></h3>
                                          <?php $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID, 'portfolio-thumbnail') ); ?>
                                          <a data-rel="prettyPhoto" href="<?php echo $url ?>" class="dmbutton a2" data-animate="fadeInUp"><i class="fa fa-search"></i></a>
                                          <a href="<?php the_permalink() ?>" class="dmbutton a2" data-animate="fadeInUp"><i class="fa fa-link"></i></a>
                                      </div>
                                  </div>
                              </div>
                          </div>
  

                        <?php if( $count == '5') { $count=0; } ?>
                        
                    <?php endwhile; wp_reset_query(); } ?>

               </div><!-- portfolio -->
        </div><!-- portfolio container -->
   </div><!--/Portfoliowrap -->

            <?php endif; //bi_port_cats check ?>
        <?php  endif; // related section enabled check ?>

            
        <?php endwhile; ?> 

        <?php else : ?>

       <article id="post-not-found" class="hentry clearfix">
        <header>
           <h1 class="title-404"><?php _e('404 &#8212; Fancy meeting you here!', 'responsive'); ?></h1>
       </header>
       <section>
           <p><?php _e('Don&#39;t panic, we&#39;ll get through this together. Let&#39;s explore our options here.', 'responsive'); ?></p>
       </section>
       <footer>
           <h6><?php _e( 'You can return', 'responsive' ); ?> <a href="<?php echo home_url(); ?>/" title="<?php esc_attr_e( 'Home', 'responsive' ); ?>"><?php _e( '&#9166; Home', 'responsive' ); ?></a> <?php _e( 'or search for the page you were looking for', 'responsive' ); ?></h6>
           <?php get_search_form(); ?>
       </footer>

   </article>

<?php endif; ?>  
      


<?php get_footer(); ?>