<?php
/**
 * Index Template
 *
 *
 * @file           index.php
 * @package        SolidWP 
 * @author         Brad Williams 
 * @copyright      2011 - 2014 GentsThemes
 * @license        license.txt
 * @version        Release: 3.2.0
 * @link           http://codex.wordpress.org/Theme_Development#Index_.28index.php.29
 * @since          available since Release 1.0
 */
?>
<?php get_header(); ?>

<!-- *****************************************************************************************************************
   BLUE WRAP
   ***************************************************************************************************************** -->
   <div id="blue">
    <div class="container">
      <div class="row">
        <h3><?php the_title(); ?></h3>
      </div><!-- /row -->
    </div> <!-- /container -->
  </div><!-- /blue -->

<!-- *****************************************************************************************************************
   BLOG CONTENT
   ***************************************************************************************************************** -->

   <div class="container mtb">
    <div class="row">

      <! -- BLOG POSTS LIST -->
      <div class="col-lg-8">

        <?php
        global $wp_query;
        if ( get_query_var('paged') ) {
          $paged = get_query_var('paged');
        } elseif ( get_query_var('page') ) {
          $paged = get_query_var('page');
        } else {
          $paged = 1;
        }
        query_posts( array( 'post_type' => 'post', 'paged' => $paged ) );
        ?>   
        <?php if (have_posts()) : ?>

        <?php while (have_posts()) : the_post(); ?>
        
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
           <?php if ( has_post_thumbnail()) : ?>
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
              <?php the_post_thumbnail(); ?>
            </a>
          <?php endif; ?>

          <header>
            <h3 class="ctitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(__('Permanent Link to %s', 'responsive'), the_title_attribute('echo=0')); ?>"><?php the_title(); ?></a></h3>
          </header>

          <?php if( bi_option('enable_disable_meta','1') == '1') {?>
          <section>
            <p>
            <?php 
            printf( __( '<span class="csmall">Posted: %2$s </span> | <span class="csmall2"> %3$s </span>', 'responsive' ),'meta-prep meta-prep-author',
              sprintf( '<a href="%1$s" title="%2$s" rel="bookmark">%3$s</a>',
               get_permalink(),
               esc_attr( get_the_time() ),
               get_the_date()
               ),
              sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s">%3$s</a></span>',
               get_author_posts_url( get_the_author_meta( 'ID' ) ),
               sprintf( esc_attr__( 'View all posts by %s', 'responsive' ), get_the_author() ),
               get_the_author()
               )
              );
              ?>
              <?php if ( comments_open() ) : ?>
              <span class="comments-link">
                <span class="mdash">&mdash;</span>
                <?php comments_popup_link(__('No Comments <i class="icon-arrow-down"></i>', 'responsive'), __('1 Comment <i class="icon-arrow-down"></i>', 'responsive'), __('% Comments <i class="icon-arrow-down"></i>', 'responsive')); ?>
              </span>
            <?php endif; ?> 
            </p>
          </section>
          <?php } ?>

          <section class="post-entry">
           
          <?php the_content(); ?>
          <?php custom_link_pages(array(
            'before' => '<nav class="pagination"><ul>' . __(''),
            'after' => '</ul></nav>',
                            'next_or_number' => 'next_and_number', # activate parameter overloading
                            'nextpagelink' => __('&rarr;'),
                            'previouspagelink' => __('&larr;'),
                            'pagelink' => '%',
                            'echo' => 1 )
                            ); ?>
                          </section><!-- end of .post-entry -->        

                        </article><!-- end of #post-<?php the_ID(); ?> -->

                        <div class="hline"></div>
        
                         <div class="spacing"></div>

                      <?php endwhile; ?> 

                      <?php if (  $wp_query->max_num_pages > 1 ) : ?>
                      <nav>
                        <ul class="pager">
                         <li class="previous"><?php next_posts_link( __( '&#8249; Older posts', 'responsive' ) ); ?></li>
                         <li class="next"><?php previous_posts_link( __( 'Newer posts &#8250;', 'responsive' ) ); ?></li>
                       </ul><!-- end of .navigation -->
                     </nav>
                   <?php endif; ?>

                 <?php else : ?>

                 <article id="post-not-found" class="hentry clearfix">
                  <header>
                   <h1 class="title-404"><?php _e('404 &#8212; Fancy meeting you here!', 'responsive'); ?></h1>
                 </header>
                 <section>
                   <p><?php _e('Don&#39;t panic, we&#39;ll get through this together. Let&#39;s explore our options here.', 'responsive'); ?></p>
                 </section>
                 <footer>
                   <h6><?php _e( 'You can return', 'responsive' ); ?> <a href="<?php echo home_url(); ?>/" title="<?php esc_attr_e( 'Home', 'responsive' ); ?>"><?php _e( '&#9166; Home', 'responsive' ); ?></a> <?php _e( 'or search for the page you were looking for', 'responsive' ); ?></h6>
                   <?php get_search_form(); ?>
                 </footer>

               </article>

             <?php endif; ?>  

           </div><! --/col-lg-8 -->

           <?php get_sidebar(); ?>
           <?php get_footer(); ?>