<?php
/**
 * File used for homepage team content
 *
 * @package WordPress
 */

  //query posts
$home_team_posts = new WP_Query(
	array(
		'post_type' => 'team',
		'showposts' =>  bi_option('home_team_count','4'),
		'no_found_rows' => true
		)
	);

	if ( $home_team_posts->posts ) : ?>

  <!-- *****************************************************************************************************************
	 TEEAM MEMBERS
	 ***************************************************************************************************************** -->

	 <div class="container mtb">
	 	<div class="row centered">
	 		<?php if(bi_option('team_heading')!== '') {?>
	 		<h3 class="mb"><?php echo bi_option('team_heading');?></h3>
	 		<?php } ?>
	 		<?php while ( $home_team_posts->have_posts() ) : $home_team_posts->the_post(); ?>
	 		<div class="col-lg-3 col-md-3 col-sm-3">
	 			<div class="he-wrap tpl6">
	 				<?php if ( has_post_thumbnail()) : ?>
	 				<?php the_post_thumbnail(); ?>
	 			<?php endif; ?>
	 			<div class="he-view">
	 				<div class="bg a0" data-animate="fadeIn">
	 					<?php if( rwmb_meta( 'wtf_team_txt' ) !== '' ) { ?>
	 					<h3 class="a1" data-animate="fadeInDown"><?php echo rwmb_meta( 'wtf_team_txt' ); ?></h3>
	 					<?php } ?>
	 					<?php if( rwmb_meta( 'wtf_team_f_icon' ) !== '' ) { ?>
	 					<a href="<?php echo rwmb_meta( 'wtf_team_f_link' ); ?>" class="dmbutton a2" data-animate="fadeInUp"><i class="fa fa-<?php echo rwmb_meta( 'wtf_team_f_icon' ); ?>"></i></a>
	 					<?php } ?>
	 					<?php if( rwmb_meta( 'wtf_team_s_icon' ) !== '' ) { ?>
	 					<a href="<?php echo rwmb_meta( 'wtf_team_s_link' ); ?>" class="dmbutton a2" data-animate="fadeInUp"><i class="fa fa-<?php echo rwmb_meta( 'wtf_team_s_icon' ); ?>"></i></a>
	 					<?php } ?>
	 				</div><!-- he bg -->
	 			</div><!-- he view -->		
	 		</div><!-- he wrap -->
	 		<h4><?php the_title(); ?></h4>
	 		<?php if( rwmb_meta( 'wtf_team_role' ) !== '' ) { ?>
	 		<h5 class="ctitle">
	 			<?php echo rwmb_meta( 'wtf_team_role' ); ?>
	 		</h5>
	 		 <?php } ?>
	 		<?php the_content(); ?>
	 		<div class="hline"></div>
	 	</div>

	 <?php endwhile; ?>

	</div><!-- /row -->
</div><!-- /container --> 
<?php endif; wp_reset_postdata(); ?>

