<?php
/**
 * Registers custom post types for use with this theme
 *
 * @package WordPress
*/

add_action( 'init', 'bi_create_post_types' );

if ( !function_exists('bi_create_post_types') ) {
	
	function bi_create_post_types() {
		  
		/******* Home Highlights Post Type *******/
		register_post_type( 'hp_highlights',
			array(
			  'labels' => array(
				'name' => __( 'HP Highlights', 'responsive' ),
				'singular_name' => __( 'Highlight', 'responsive' ),		
				'add_new' => _x( 'Add New', 'Highlight', 'responsive' ),
				'add_new_item' => __( 'Add New Highlight', 'responsive' ),
				'edit_item' => __( 'Edit Highlight', 'responsive' ),
				'new_item' => __( 'New Highlight', 'responsive' ),
				'view_item' => __( 'View Highlight', 'responsive' ),
				'search_items' => __( 'Search Highlights', 'responsive' ),
				'not_found' =>  __( 'No Highlights found', 'responsive' ),
				'not_found_in_trash' => __( 'No Highlights found in Trash', 'responsive' ),
				'parent_item_colon' => ''
				
			  ),
			  'public' => true,
			  'supports' => array('title','editor','thumbnail','revisions','custom-fields'),
			  'query_var' => true,
			  'rewrite' => array( 'slug' => 'hp-highlights' ),
			  'has_archive' => false,
			  'show_in_nav_menus' => false,
			  'menu_icon' => get_template_directory_uri() . '/images/admin/icon-highlights.png',
			)
		  );

		/******* Clients Post Type *******/
		register_post_type( 'Clients',
			array(
			  'labels' => array(
				'name' => __( 'Clients', 'responsive' ),
				'singular_name' => __( 'Client', 'responsive' ),		
				'add_new' => _x( 'Add New', 'Client', 'responsive' ),
				'add_new_item' => __( 'Add New Client', 'responsive' ),
				'edit_item' => __( 'Edit Client', 'responsive' ),
				'new_item' => __( 'New Client', 'responsive' ),
				'view_item' => __( 'View Client', 'responsive' ),
				'search_items' => __( 'Search Clients', 'responsive' ),
				'not_found' =>  __( 'No Clients found', 'responsive' ),
				'not_found_in_trash' => __( 'No Clients found in Trash', 'responsive' ),
				'parent_item_colon' => ''
				
			  ),
			  'public' => true,
			  'supports' => array('title','thumbnail','revisions'),
			  'query_var' => true,
			  'rewrite' => array( 'slug' => 'clients' ),
			  'has_archive' => false,
			  'show_in_nav_menus' => false,
			)
		  );


			/******* Team Post Type *******/

		$team_slug = ( bi_option('team_post_type_slug') ) ? bi_option('team_post_type_slug') : 'team';
		$team_post_type_name = ( bi_option('team_post_type_name') ) ? bi_option('team_post_type_name') : __('Team','responsive');
		$team_labels = array( 'name' => $team_post_type_name );

		register_post_type( 'Team',
			array(
			  'labels' => apply_filters('bi_team_labels', $team_labels),
			  'public' => true,
			  'has_archive' => false,
			  'supports' => array('title','editor','thumbnail','revisions','comments','custom-fields'),
			  'query_var' => true,
			  'rewrite' => array( 'slug' => $team_slug ),
			  'menu_icon' => get_template_directory_uri() . '/images/admin/icon-staff.png',
			)
		  );
	
	
	
		/******* Portfolio Post Type *******/
	
		$portfolio_slug = ( bi_option('portfolio_post_type_slug') ) ? bi_option('portfolio_post_type_slug') : 'portfolio';
		$portfolio_post_type_name = ( bi_option('portfolio_post_type_name') ) ? bi_option('portfolio_post_type_name') : __('Portfolio','responsive');
		$portfolio_labels = array( 'name' => $portfolio_post_type_name );
		
		register_post_type( 'Portfolio',
			array(
			  'labels' => apply_filters('bi_portfolio_labels', $portfolio_labels),
			  'public' => true,
			  'has_archive' => false,
			  'supports' => array('title','editor','thumbnail','revisions','comments','custom-fields'),
			  'query_var' => true,
			  'rewrite' => array( 'slug' => $portfolio_slug ),
			  'menu_icon' => get_template_directory_uri() . '/images/admin/icon-portfolio.png',
			)
		  );
		
		
		/******* Testimonials Post Type *******/
		
		$testimonials_slug = ( bi_option('testimonials_post_type_slug') ) ? bi_option('testimonials_post_type_slug') : 'testimonials';
		$testimonials_post_type_name = ( bi_option('testimonials_post_type_name') ) ? bi_option('testimonials_post_type_name') : __('Testimonials','responsive');
		$testimonials_labels = array( 'name' => $testimonials_post_type_name );
		
		register_post_type( 'testimonials',
			array(
			  'labels' => apply_filters('bi_testimonials_labels', $testimonials_labels),
			  'public' => true,
			  'has_archive' => false,
			  'supports' => array('title', 'revisions','comments','thumbnail','editor'),
			  'menu_icon' => get_template_directory_uri() . '/images/admin/icon-testimonials.png',
			  'query_var' => true,
			  'rewrite' => array( 'slug' => $testimonials_slug ),
			)
		  );
	
	}
}