<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/
 */

/********************* META BOX DEFINITIONS ***********************/

/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
$prefix = 'wtf_';

global $meta_boxes;

$meta_boxes = array();

// Post Type name
	$portfolio_post_type_name = ( bi_option('portfolio_post_type_name') ) ? bi_option('portfolio_post_type_name') : __('Portfolio','responsive');

	//Individual Portfolio
	$meta_boxes[] = array(
		'id'         => 'portfolio_metabox',
		'title'      => 'Options',
		'pages'      => array( 'portfolio', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true,
		'fields'     => array(
			array(
				'name' => __('Right of Content','responsive'),
				'desc' => __('This is the content that will be displayed on the right. Optional.','responsive'),
				'id' => $prefix . 'portfolio_right',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 6,
				'std' => '<h4>Project Details</h4>
                <div class="hline"></div>
                <p><b>Date:</b> April 18, 2014</p>
                <p><b>Author:</b> Marcel Newman</p>
                <p><b>Categories:</b> Illustration, Web Design, Wordpress</p>
                <p><b>Tagged:</b> Flat, UI, Development</p>
                <p><b>Client:</b> Wonder Corp.</p>
                <p><b>Website:</b> <a href="http://gentstheme.com">http://gentsthemes.com</a></p>',
			),
			array(
				'name'             => __( 'Slider Images', 'responsive' ),
				'id'               => $prefix . 'imgadv',
				'type'             => 'image_advanced',
				'max_file_uploads' => 10,
			),
			array(
				'name'    => __( 'Show Related Items', 'responsive' ),
				'id'      => $prefix . 'single_port_radio',
				'type'    => 'radio',
				'options' => array(
					'value1' => __( 'Yes', 'responsive' ),
					'value2' => __( 'No', 'responsive' ),
				),
			),
		),
	);


	// Portfolio Page
	$meta_boxes[] = array(
		'title'  => __( 'Options', 'responsive' ),
		'pages' => array('page'),
		'fields' => array(
				array(
					'name' => __('Title','responsive'),
					'desc' => __('Enter the text to be displayed above the portfolio items. ','responsive'),
					'id' => $prefix . 'portfolio_title',
					'type' => 'textarea',
					'cols' => 20,
					'rows' => 3,
					'std'  => '<h2>We create awesome designs to make your site or product standout. Check out our latest works.</h2>',
				),
		),
		'only_on'    => array(
			'template' => array( 'template-portfolio.php' )
		),
	);


	//Individual Team Member
	$meta_boxes[] = array(
		'id'         => 'team_metabox',
		'title'      => 'Options',
		'pages'      => array( 'Team', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true,
		'fields'     => array(
			array(
				'name' => __('Role','responsive'),
				'desc' => __('Enter the text to be displayed under name. ','responsive'),
				'id' => $prefix . 'team_role',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'CEO',
			),
			array(
				'name' => __('Share Text','responsive'),
				'desc' => __('Enter the text to be displayed above the share icons. ','responsive'),
				'id' => $prefix . 'team_txt',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'CONTACT ME',
			),
			array(
				'name' => __('First Share Icon','responsive'),
				'desc' => __('Enter the Font Awesome icon name to use for the share icon. ','responsive'),
				'id' => $prefix . 'team_f_icon',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'facebook',
			),
			array(
				'name' => __('First Share Link','responsive'),
				'desc' => __('Enter the link for the first share icon. ','responsive'),
				'id' => $prefix . 'team_f_link',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'http://facebook.com',
			),
			array(
				'name' => __('Second Share Icon','responsive'),
				'desc' => __('Enter the Font Awesome icon name to use for the share icon. ','responsive'),
				'id' => $prefix . 'team_s_icon',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'twitter',
			),
			array(
				'name' => __('Second Share Link','responsive'),
				'desc' => __('Enter the link for the second share icon. ','responsive'),
				'id' => $prefix . 'team_s_link',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'http://twitter.com',
			),
		),
	);


// About
$meta_boxes[] = array(
	'title'  => __( 'Options', 'responsive' ),
	'pages' => array('page'),
	'fields' => array(
			array(
				'name'    => __( 'Show Team', 'responsive' ),
				'id'      => $prefix . 'about_radio',
				'type'    => 'radio',
				'options' => array(
					'value1' => __( 'Yes', 'responsive' ),
					'value2' => __( 'No', 'responsive' ),
				),
			),
			array(
				'name'    => __( 'Show Latest Testimonial', 'responsive' ),
				'id'      => $prefix . 'test_radio',
				'type'    => 'radio',
				'options' => array(
					'value1' => __( 'Yes', 'responsive' ),
					'value2' => __( 'No', 'responsive' ),
				),
			),
			array(
				'name'    => __( 'Show Clients', 'responsive' ),
				'id'      => $prefix . 'client_radio',
				'type'    => 'radio',
				'options' => array(
					'value1' => __( 'Yes', 'responsive' ),
					'value2' => __( 'No', 'responsive' ),
				),
			),

	),
	'only_on'    => array(
		'template' => array( 'template-about.php' )
	),
);

	// Individual Testimonial
	$meta_boxes[] = array(
		'id'         => 'team_metabox',
		'title'      => 'Options',
		'pages'      => array( 'Testimonials', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true,
		'fields'     => array(
			array(
				'name' => __('Icon','responsive'),
				'desc' => __('Enter the Font Awesome Icon to display. ','responsive'),
				'id' => $prefix . 'test_icon',
				'type' => 'text',
				'std'  => 'comment-o',
			),
			array(
				'name' => __('Text under Title','responsive'),
				'desc' => __('Enter the text you would like under the title. ','responsive'),
				'id' => $prefix . 'test_txt',
				'type' => 'textarea',
				'cols' => 20,
				'rows' => 3,
				'std'  => 'WEB DESIGNER - BLACKTIE.CO',
			),
		),
	);

	// Homepage Highlights
	$meta_boxes[] = array(
		'id'         => 'highlights_metabox',
		'title'      => 'Options',
		'pages'      => array( 'hp_highlights', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true,
		'fields'     => array(
			array(
				'name' => __('Icon','responsive'),
				'desc' => __('Enter the Font Awesome Icon to display. ','responsive'),
				'id' => $prefix . 'hp_highlights_icon',
				'type' => 'text',
				'std'  => 'heart-o',
			),
		),
	);


/********************* META BOX REGISTERING ***********************/

/**
 * Register meta boxes
 *
 * @return void
 */
function wtf_register_meta_boxes()
{
	global $meta_boxes;

	// Make sure there's no errors when the plugin is deactivated or during upgrade
	if ( class_exists( 'RW_Meta_Box' ) ) {
		foreach ( $meta_boxes as $meta_box ) {
			if ( isset( $meta_box['only_on'] ) && ! rw_maybe_include( $meta_box['only_on'] ) ) {
				continue;
			}

			new RW_Meta_Box( $meta_box );
		}
	}
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'wtf_register_meta_boxes' );

/**
 * Check if meta boxes is included
 *
 * @return bool
 */
function rw_maybe_include( $conditions ) {
	// Include in back-end only
	if ( ! defined( 'WP_ADMIN' ) || ! WP_ADMIN ) {
		return false;
	}

	// Always include for ajax
	if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
		return true;
	}

	if ( isset( $_GET['post'] ) ) {
		$post_id = $_GET['post'];
	}
	elseif ( isset( $_POST['post_ID'] ) ) {
		$post_id = $_POST['post_ID'];
	}
	else {
		$post_id = false;
	}

	$post_id = (int) $post_id;
	$post    = get_post( $post_id );

	foreach ( $conditions as $cond => $v ) {
		// Catch non-arrays too
		if ( ! is_array( $v ) ) {
			$v = array( $v );
		}

		switch ( $cond ) {
			case 'id':
				if ( in_array( $post_id, $v ) ) {
					return true;
				}
			break;
			case 'parent':
				$post_parent = $post->post_parent;
				if ( in_array( $post_parent, $v ) ) {
					return true;
				}
			break;
			case 'slug':
				$post_slug = $post->post_name;
				if ( in_array( $post_slug, $v ) ) {
					return true;
				}
			break;
			case 'template':
				$template = get_post_meta( $post_id, '_wp_page_template', true );
				if ( in_array( $template, $v ) ) {
					return true;
				}
			break;
		}
	}

	// If no condition matched
	return false;
}
?>