﻿
function DisplayAppointments(){
    var apptId="";
    var appt;
    var cellId="";
    var cell;
    var nbUnits;
    var height;
    var cellHeight;
    var leftMargin;
    var h=0;
    for (i=0;i<1000;i++){
        apptId="APPT"+i.toString();
        appt=document.getElementById(apptId);
        if (appt){
            cellId=appt.dataset.cell;
            cell=document.getElementById(cellId);
            if (cell){
                nbUnits = parseInt(appt.dataset.nbunits);
                h = parseInt(cell.offsetHeight);
                leftMargin = parseInt(appt.style.marginLeft);
                if (isNaN(leftMargin) )
                    leftMargin = 0;
                cellHeight = h;
                h=h*nbUnits
                h=h+nbUnits;
                if (cellHeight > 12)
                    h=h-1;
                height=h;
                appt.offsetHeight =height+"px";
                appt.style.height = (height - 4) + "px";
                appt.style.width = (cell.offsetWidth - 4 - leftMargin/2) + "px";
                SetPosition(apptId,cellId);
            }
        }else
           break;
    }

    for (i=0;i<1000;i++){
        apptId="APPT"+i.toString();
        appt=document.getElementById(apptId);
        if (appt){
            appt.style.visibility='visible';
        }
    }
    
}
function SetPosition(ctrl, Indiv){
   SetPos(ctrl,getPosition(Indiv).x-1,getPosition(Indiv).y-1);
}

function getPosition(ctrl){
	var e=document.getElementById(ctrl);
	
	var left = 0;
	var top  = 0;

	while (e.offsetParent){
		left += e.offsetLeft;
		top  += e.offsetTop;
		e     = e.offsetParent;
	}

	left += e.offsetLeft;
	top  += e.offsetTop;

	return {x:left, y:top};
}

function SetPos(control,x,y){
    var ctrl=document.getElementById(control);
    if (ctrl){
		ctrl.style.position = 'absolute';
		ctrl.style.top      = y+"px";
		ctrl.style.left     = x+"px";
        
    }
}


function ResizeCell(increment){
    var ctrl = document.getElementById("C0R0");
    if (ctrl){
        var height=parseInt(ctrl.offsetHeight);
        height=height+increment;
        if (height<12)
            height=12;
        if (height>100)
            height=100;    
        var id="";
        for (c=0;c<1000;c++){
            id="C"+c+"R0";
            ctrl=document.getElementById(id);
            if (ctrl){
                for (r=0;r<1000;r++){
                    id="C"+c+"R"+r;
                    ctrl=document.getElementById(id);
                    if (ctrl){
                        ctrl.style.height= height+"px";
                    }else
                        break;
                }
            }else
                        break;
        }
    }
    DisplayAppointments();
}

var apptBgColor;
var apptColor;

function ChangeZindex(ctrlName, value) {
    var ctrl = document.getElementById(ctrlName);
    if (ctrl) {
        ctrl.style.zIndex = value;
        if (value == '10') {
            var w = parseInt(ctrl.style.width);
            apptBgColor = ctrl.style.backgroundColor;
            apptColor = ctrl.style.color;
            ctrl.style.color = "red";
            ctrl.style.backgroundColor = "white";
            w = w * 1.2;
            ctrl.style.width = w + "px";
            var h = parseInt(ctrl.style.height);
            if (h < 150)
               h = h * 1.2;
            if (h < 130)
                h = 130;
            ctrl.style.height = h + "px";
            ctrl.style.fontSize = "large";

        } else {
            ctrl.style.backgroundColor = apptBgColor;
            ctrl.style.color = apptColor;
            var w = parseInt(ctrl.style.width);
            w = w / 1.2;
            ctrl.style.width = w + "px";
            ctrl.style.fontSize = "x-small";
            
            
            var cellId=ctrl.dataset.cell;
            var cell=document.getElementById(cellId);
            if (cell) {
                h = parseInt(cell.offsetHeight);
                var cellHeight = h;
                nbUnits = parseInt(ctrl.dataset.nbunits);
                h = h * nbUnits
                h = h + nbUnits;
                if (cellHeight > 12)
                    h = h - 1;
                ctrl.offsetHeight = h + "px";
                ctrl.style.height = (h - 4) + "px";

            }
            
        }
    }
}

var expandTimer;
var xExpansion = 0;
var yExpansion = 0;

function ExpandOverlap(column) {
    expandTimer = setInterval(function() { ExpandOverlapTimer(column) }, 10);
    xExpansion = 0;
    yExpansion = 0;
}

function ExpandOverlapTimer(column) {
    window.clearTimeout(expandTimer);
    var id = '';
    var ctrl = '';
    var over = false;
    for (a = 0; a < 1000; a++) {
        id = "APPT" + a;
        ctrl = document.getElementById(id);
        if (ctrl) {
            if (ctrl.dataset.column == column) {
                var s = ctrl.dataset.overlaporder;
                var i = parseInt(ctrl.style.marginLeft);
                i = i * 1.25;
                ctrl.style.marginLeft = i + "px";
                if (i >= 100) {
                    over = true;
                }

                i = parseInt(ctrl.style.marginTop);
                i = i * 1.32;
                ctrl.style.marginTop = i + "px";

                if (s == "") {
                    ctrl.style.zIndex = 10;
                } else {
                    ctrl.style.zIndex = 11;
                }
            }
        } 
    }
    if (!over)
        expandTimer = setInterval(function() { ExpandOverlapTimer(column) }, 20);
}



function ShrinkOverlap(column) {
    window.clearTimeout(expandTimer);
    var id = '';
    var ctrl = '';
    for (a = 0; a < 1000; a++) {
        id = "APPT" + a;
        ctrl = document.getElementById(id);
        if (ctrl) {
            if (ctrl.dataset.column == column) {
                var s = ctrl.dataset.overlaporder;

                var i = parseInt(s);
                ctrl.style.marginLeft = i + "px";
                ctrl.style.marginTop = i + "px";

                ctrl.style.zIndex = 1;
                
            }
        }
    }
}